/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.util;

import com.ibm.hwmca.fw.pa.util.CallbackTimerTaskInterface;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public final class CallbackTimerTask
extends TimerTask {
    private static final String TRACE_MASKT = "XPACTTAT";
    private static final String TRACE_MASKF = "XPACTTAF";
    private static final String TRACE_MASKD = "XPACTTAD";
    private static Timer timer = new Timer(true);
    private CallbackTimerTaskInterface callbackObject = null;

    public CallbackTimerTask(CallbackTimerTaskInterface callbackObject) {
        this.callbackObject = callbackObject;
    }

    public void run() {
        try {
            this.callbackObject.timerPopped();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "Uncaught exception from callback timerPopped()");
            Trace.trace(TRACE_MASKT, e);
        }
    }

    public boolean cancel() {
        if (timer == null) {
            return false;
        }
        boolean rc = super.cancel();
        try {
            this.callbackObject.timerCancelled();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "Uncaught exception from callback timerCancelled()");
            Trace.trace(TRACE_MASKT, e);
        }
        return rc;
    }

    public void clear() {
        if (timer == null) {
            return;
        }
        super.cancel();
    }

    public static void terminate() {
        timer.cancel();
        timer = null;
    }

    public long scheduledExecutionTime() {
        if (timer == null) {
            return 0L;
        }
        return this.scheduledExecutionTime();
    }

    public void schedule(Date time) {
        if (timer != null) {
            timer.schedule((TimerTask)this, time);
        }
    }

    public void schedule(Date firstTime, long period) {
        if (timer != null) {
            timer.schedule((TimerTask)this, firstTime, period);
        }
    }

    public void schedule(long delay) {
        if (timer != null) {
            timer.schedule((TimerTask)this, delay);
        }
    }

    public void schedule(long delay, long period) {
        if (timer != null) {
            timer.schedule((TimerTask)this, delay, period);
        }
    }

    public void scheduleAtFixedRate(Date firstTime, long period) {
        if (timer == null) {
            timer.scheduleAtFixedRate((TimerTask)this, firstTime, period);
        }
    }

    public void scheduleAtFixedRate(long delay, long period) {
        if (timer == null) {
            timer.scheduleAtFixedRate((TimerTask)this, delay, period);
        }
    }
}

